//
//  FJDCoreDataAppDelegate.m
//  FJDCoreDataWindow
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJDCoreDataAppDelegate.h"
#import "FJDCoreDataWindowController.h"


@implementation FJDCoreDataAppDelegate


- (void)dealloc
{
	[coreDataWindowControllers release];
	
	[super dealloc];
}

#pragma mark Accessor methods

- (void)setCoreDataWindowControllers:(NSArray *)array
{
	if (coreDataWindowControllers != array) {
		[coreDataWindowControllers release];
		coreDataWindowControllers = [array copy];
	}
}

- (NSArray *)coreDataWindowControllers
{
	return coreDataWindowControllers;
}

#pragma mark Methods delegated by NSApplication

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
    int reply = NSTerminateNow;
    NSError *error;
    
	NSEnumerator *enumerator = [[self coreDataWindowControllers] objectEnumerator];
	FJDCoreDataWindowController *coreDataWindowController;
	
	while (coreDataWindowController = [enumerator nextObject]) {
		NSManagedObjectContext *managedObjectContext = [coreDataWindowController managedObjectContext];
		
		if (managedObjectContext != nil) {
			if ([managedObjectContext commitEditing]) {
				if ([managedObjectContext hasChanges] && ![managedObjectContext save:&error]) {
				
					// This error handling simply presents error information in a panel with an 
					// "Ok" button, which does not include any attempt at error recovery (meaning, 
					// attempting to fix the error.)  As a result, this implementation will 
					// present the information to the user and then follow up with a panel asking 
					// if the user wishes to "Quit Anyway", without saving the changes.
					
					// Typically, this process should be altered to include application-specific 
					// recovery steps.
					
					BOOL errorResult = [[NSApplication sharedApplication] presentError:error];
					
					if (errorResult == YES) {
						reply = NSTerminateCancel;
						return reply;
					} else {
						int alertReturn = NSRunAlertPanel(nil, 
														  NSLocalizedStringFromTable(@"Could not save changes while quitting. Quit anyway?", @"CoreDataLocalizable", nil),
														  NSLocalizedStringFromTable(@"Quit anyway", @"CoreDataLocalizable", nil), 
														  NSLocalizedStringFromTable(@"Cancel", @"CoreDataLocalizable", nil),
														  nil);
						if (alertReturn == NSAlertAlternateReturn) {
							reply = NSTerminateCancel;
							return reply;
						}
					}
				}
			} else {
				reply = NSTerminateCancel;
				return reply;
			}
		}
    }
    
    return reply;
}


@end
